<?php

namespace Ignite\Catalog\Tests\Unit\Models\Product\Classifications;

use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Models\Product\Classifications\Egift;
use Ignite\Catalog\Tests\TestCase;

class EgiftTest extends TestCase
{
    /** @var Egift */
    protected $egift;

    public function setUp() : void
    {
        parent::setUp();

        $this->egift = new Egift(new Item());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_a_physical_product()
    {
        $this->assertFalse($this->egift->isPhysical());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_a_reloadable_product()
    {
        $this->assertFalse($this->egift->isReloadable());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_an_open_loop_product()
    {
        $this->assertFalse($this->egift->isOpenLoop());
    }
}
