<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Illuminate\Support\Collection;
use Ignite\Catalog\Entities\Order;

class PrepaidAnonymousBulk extends VendorHandler
{
    /**
     * @inheritdoc
     */
    public function enabled(): bool
    {
        return (bool)config('catalog.vendors.hawk.prepaid.anonymous.bulk')
            ?? (bool)config('catalog.vendors.hawk.prepaid.anonymous')
            ?? (bool)config('catalog.vendors.hawk.prepaid');
    }

    /**
     * @inheritdoc
     */
    protected function job(Order $order, Collection $orderItems)
    {
        return \Ignite\Catalog\Jobs\Hawk\PrepaidAnonymousBulk::class;
    }
}
