<?php

namespace Ignite\Catalog\Providers;

use Ignite\Catalog\Events\OrderSubmitted;
use Ignite\Catalog\Listeners\Menus\AddCatalogMenu;
use Ignite\Catalog\Listeners\Menus\AddCatalogToParticipantActionMenu;
use Ignite\Catalog\Listeners\Menus\AddCatalogToParticipantPanel;
use Ignite\Catalog\Listeners\Menus\AddCatalogItemsToNavigationMenu;
use Ignite\Catalog\Events\IncompleteHawkOrder;
use Ignite\Catalog\Listeners\DeleteCatalogRelationsWhenDeletingParticipant;
use Ignite\Catalog\Listeners\RequestHawkOrderInfo;
use Ignite\Catalog\Listeners\SendOrderConfirmation;
use Ignite\Core\Events\EnrollmentDeleting;
use Ignite\Core\Events\Menus\ActionMenuPreCompile;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\ParticipantMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        NavigationMenuPreCompile::class => [
            AddCatalogItemsToNavigationMenu::class
        ],
        UserMenuPreCompile::class => [
            AddCatalogItemsToNavigationMenu::class
        ],
        AdminMenuPreCompile::class => [
            AddCatalogMenu::class
        ],
        ParticipantMenuPreCompile::class => [
            AddCatalogToParticipantPanel::class
        ],
        ActionMenuPreCompile::class => [
            AddCatalogToParticipantActionMenu::class
        ],
        EnrollmentDeleting::class => [
            DeleteCatalogRelationsWhenDeletingParticipant::class
        ],
        OrderSubmitted::class => [
            SendOrderConfirmation::class
        ],
        IncompleteHawkOrder::class => [
            RequestHawkOrderInfo::class
        ]
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [];
}
