<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk;

use Ignite\Catalog\Models\Hawk\EGiftIndividualOrderLine;
use Ignite\Tests\TestCase;

class EGiftIndividualOrderLineTest extends TestCase
{
    private $recipientFixture = [
        'firstName' => 'John',
        'lastName' => 'Smith',
        'email' => 'johnsmith@gmail.com'
    ];

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_create_an_instance_from_an_associated_array()
    {
        $this->assertInstanceOf(EGiftIndividualOrderLine::class, EGiftIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target_eGift',
            'recipient' => $this->recipientFixture
        ]));
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_amount_is_not_numeric()
    {
        EGiftIndividualOrderLine::fromAssociativeArray([
            'amount' => "moneys",
            'contentProvider' => 'Target_eGift',
            'recipient' => $this->recipientFixture
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_description_exceeds_character_limit()
    {
        EGiftIndividualOrderLine::fromAssociativeArray([
            'amount' => 25,
            'contentProvider' => 'Target_eGift',
            'description' => str_repeat('X', 41),
            'recipient' => $this->recipientFixture
        ]);
    }
}
