<?php

namespace Ignite\Catalog\Http\Forms;

use Exception;
use Ignite\Catalog\Models\Cart;
use Ignite\Core\Models\Form\CoreForm;

class CheckoutForm extends CoreForm
{
    /**
     * Build the form.
     *
     * @return self
     * @throws Exception
     */
    public function buildForm()
    {
        try {
            $this->buildFromSchema('checkout');

            $this->setFormOptions([
                'id' => 'checkout-form',
                'novalidate'
            ]);

            if ($user = $this->getData('user')) {
                $this->setFormFieldDefaultValue('first', $user->participant->first);
                $this->setFormFieldDefaultValue('last', $user->participant->last);
                $this->setFormFieldDefaultValue('ship_phone', $user->participant->phone1);
                $this->setFormFieldDefaultValue('ship_email', $user->participant->email);
                $this->setFormFieldDefaultValue('ship_address_1', $user->participant->address_1);
                $this->setFormFieldDefaultValue('ship_address_2', $user->participant->address_2);
                $this->setFormFieldDefaultValue('ship_address_3', $user->participant->address_3);
                $this->setFormFieldDefaultValue('ship_city', $user->participant->city);
                $this->setFormFieldDefaultValue('ship_state', $user->participant->state);
                $this->setFormFieldDefaultValue('ship_postal', $user->participant->postal);
                $this->setFormFieldDefaultValue('ship_country', $user->participant->country);
            }

            /** @var Cart $cart */
            if ($cart = $this->getData('cart')) {
                $this->getField('first')->setOption('rules', ['required', 'max:255']);
                $this->getField('last')->setOption('rules', ['required', 'max:255']);
                $this->getField('ship_phone')->setOption('rules', ['required', 'max:255']);

                if ($cart->hasNonPhysical()) {
                    $this->getField('ship_email')->setOption('rules', ['required', 'email', 'max:255']);
                    $this->getField('ship_email')->setOption('help_block.text', __(
                            'Catalog::theme.checkout.form.email.help.card', [
                            'card' => str_plural('card', $cart->countNonPhysical())
                        ])
                    );
                }

                if ($cart->hasOnlyNonPhysical()) {
                    $this->remove([
                        'ship_address_1', 'ship_address_2', 'ship_address_3',
                        'ship_city', 'ship_state', 'ship_postal', 'ship_country'
                    ]);
                }
            }
        } catch (Exception $e) {
            // Developer should handle this?
            throw $e;
        }

        return $this;
    }

    /**
     * Set the default value for the form field by name and the given user value.
     *
     * @param string $name
     * @param string $value
     *
     * @return void
     */
    protected function setFormFieldDefaultValue($name, $value)
    {
        $field = $this->getField($name);

        if ($field->getName() === $name) {
            $field->setOption('attr.data-initial', $value);
            $field->setRawValue($value);
            $field->setValue($value);

            if (in_array($field->getType(), ['choice', 'select'])) {
                $field->setOption('selected', $value);
            }
        }
    }
}
