<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Core\Entities\Group;
use Ignite\Core\Entities\Permission;

/**
 * php artisan db:seed --class="Ignite\Catalog\Database\Seeders\GroupPermissionTableSeeder"
 */
class GroupPermissionTableSeeder extends AbstractCatalogSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('group_permission.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();
        $permissions = Permission::whereIn('key', $sources->pluck('permission_key'))
            ->get()
            ->keyBy('key');

        if ($permissions->isEmpty()) {
            echo 'No permissions were seeded.';
            return;
        }

        foreach ($sources as $source) {
            try {
                /** @var Group $group */
                $groups = Group::whereIn('key', explode('|', $source['group_name']))->get();
                $permission = $permissions[$source['permission_key']];
                foreach ($groups as $group) {
                    $hasPermission = $group->hasPermission($permission);
                    if (! $hasPermission) {
                        // echo "Giving {$permission->key} to {$group->name}" . PHP_EOL;
                        $group->givePermissionTo($permission);
                    } elseif ($hasPermission) {
                        // echo "Already has permission {$permission->key} for {$group->name}" . PHP_EOL;
                    }
                }
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
