<?php

namespace Ignite\Catalog\Http\Views;

use Illuminate\View\View;
use Ignite\Catalog\Entities\Menu;

class CategoriesComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $catalogId = session()->get('catalog.id');
        $menu = Menu::with([
            'items',
            'items.parent',
            'items.children',
            'items.category',
            'items.associated'
        ])->where('catalog_id', $catalogId)->first();

        $view->with('id', $catalogId);
        $view->with('code', session()->get('catalog.code'));
        $view->with('menu', $menu);
    }
}
