<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Model;

class Option extends Model
{
    /** @var string */
    protected $table = 'catalog_item_option';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    protected $guarded = [];

    /**
     * The relationship to the catalog.
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function item()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Item::class, 'item_id', 'id');
    }

    /**
     * The relationship to the super item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function super()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Item::class, 'super_id', 'id');
    }

    /**
     * The relationship to the attribute.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function attribute()
    {
        return $this->hasOne(\Ignite\Catalog\Entities\Attribute::class, 'id', 'attribute_id');
    }
}
