<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk\Response;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Ignite\Catalog\Models\Hawk\Response\SubmitEGiftIndividualResponse;
use Ignite\Tests\TestCase;
use Psr\Http\Message\ResponseInterface;

class SubmitEGiftIndividualResponseTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @var array
     */
    protected $data = [
        'transactionId' => 'XH012K7LX24',
        'orderNumber' =>  '100000102131',
        'isCompleted' => true,
        'percentComplete' =>  100,
        'success' =>  true,
    ];

    /**
     * Set up the test.
     *
     * @return void
     */
    public function setUp() : void
    {
        parent::setUp();
    }

    /**
     * Tear down the test.
     *
     * @return void
     */
    public function tearDown()
    {
        //$this->resetDatabase();
        parent::tearDown();
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_transform_response_body_into_an_instance()
    {
        $mock = \Mockery::mock(ResponseInterface::class);
        $mock->shouldReceive('getBody')->andReturn("{\"success\": true, \"isCompleted\": true, \"orderNumber\": \"303245524\", \"transactionId\": \"DVS6XZ7D0DT27V3SR2HM9BDZH8\", \"percentComplete\": 100}");

        $response = SubmitEGiftIndividualResponse::fromHttpResponse($mock);

        $this->assertInternalType('array', $response->toArray());
        $this->assertEquals('DVS6XZ7D0DT27V3SR2HM9BDZH8', $response->getTransactionId());
        $this->assertEquals('303245524', $response->getOrderNumber());
        $this->assertEquals(100, $response->getPercentComplete());
        $this->assertEquals(true, $response->getIsCompleted());
        $this->assertEquals(true, $response->getSuccess());
    }
}
