<?php

namespace Ignite\Catalog\Scopes;

use Ignite\Catalog\Entities\Cart;
use Ignite\Catalog\Entities\Order;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class ParticipantScope implements Scope
{
    /**
     * Apply the scope.
     *
     * @param Builder $builder
     * @param Model $model
     *
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $builder->macro('orders', function (Builder $builder) {
            return $builder->getModel()->hasMany(Order::class, 'user_id', 'user_id');
        });

        $builder->macro('cart', function (Builder $builder) {
            return $builder->getModel()->hasMany(Cart::class, 'user_id', 'user_id');
        });
    }
}
