@extends('Catalog::layouts.master')

@section('page_heading', trans('Catalog::vendor.misc.show.heading', ['name' => $vendor->name]))
@section('page_breadcrumb', trans('Catalog::vendor.misc.show.heading', ['name' => $vendor->name]))

@section('page_content')
    <div class="row">
        <div class="col-sm-3">
            @component('Core::admin.components.box')
                @slot('title')
                    {{ ucwords($vendor->name) }} <small>{{ $vendor->type }}</small>
                @endslot
                @component('Core::admin.components.data-list')
                    @foreach ($vendor->toPresentableArray() as $key => $value)
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', str_replace('_', ' ', title_case($key)))
                            {!! $value !!}
                        @endcomponent
                    @endforeach
                @endcomponent
           @endcomponent

            @component('Core::admin.components.menu-buttons')
                @component('Core::admin.components.menu-button')
                    @slot('link', route('admin.catalog.vendors.index'))
                    @slot('icon', 'fa fa-chevron-left')
                    <span>{{ trans('Core::core.buttons.back') }}</span>
                @endcomponent
                @component('Core::admin.components.menu-button', ['classes' => 'delete-entry'])
                    @slot('link', route('admin.catalog.vendors.destroy', $vendor))
                    @slot('icon', 'fa-trash text-danger')
                    <span class="text-danger">{{ trans('Core::core.buttons.delete') }}</span>
                @endcomponent
            @endcomponent
       </div>
       <div class="col-sm-9">
           @component('Core::admin.components.box')
               {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
           @endcomponent
       </div>
   </div>
@endsection

@section('js')
   @parent
   <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
   {!! $dataTable->scripts() !!}
   <script type="text/javascript">
       $(document).ready(function() {
           var table = $('#dataTableBuilder').DataTable();
           table.on('draw', function () {
               $('[data-toggle="tooltip"]').tooltip();
           });

           $.deleteEntry({
               confirmation: "{{ trans('Catalog::vendor.delete.confirm') }}",
               request: { method: 'DELETE', type: 'json' },
               data: function (button) {
                   return {
                       _token: "{{ csrf_token() }}",
                       id: button.attr('href').split('/').pop()
                   }
               },
               onSuccess: function(button, result) {
                   if (result.status === 'success') {
                     setTimeout(function () {
                       window.location.href = "{{ route('admin.catalog.vendors.index') }}";
                     }, 1000);
                   }
               }
           });
       });
   </script>
@endsection
