<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Core\Models\Grid\Formatter;

class VendorFormatter extends Formatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->id);
    }

    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Catalog\Entities\Order $model
     * @return HtmlString
     */
    public function actions($model)
    {
        $actions = [
            [
                'click' => '',
                'class' => '',
                'icon' => 'pencil',
                'label' => trans('Core::core.buttons.edit'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.vendors.edit', [
                    'vendor' => $model->id
                ])
            ],
            [
                'click' => '',
                'class' => '',
                'icon' => 'eye',
                'label' => trans('Core::core.buttons.view'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.vendors.show', [
                    'vendor' => $model->id
                ])
            ],
        ];

        return $this->html($this->buttons($actions));
    }

    /**
     * Format a vendor name with a link.
     *
     * @param  \stdClass $vendor
     * @return HtmlString
     */
    public function name($model)
    {
        return new HtmlString(sprintf('<a href="%s">%s</a>', route('admin.catalog.vendors.show', $model->id), $model->name));
    }

    /**
     * Format whether an order has been processed.
     *
     * @param  \stdClass $model
     * @return HtmlString
     */
    public function active($model)
    {
        return $this->html($this->formatYesNo(optional($model)->active));
    }
}
