<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Menu;
use Ignite\Catalog\Entities\MenuItem;

class CatalogMenuItemTableSeeder extends AbstractCatalogSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('catalog_menu.json'),
            'headers' => true
        ]);

        $menus = $strategy->run();

        try {
            foreach ($menus as $menu) {
                Menu::updateOrCreate([
                    'name' => $menu['name']
                ], $menu);
            }
        } catch (\Exception $e) {
        }

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('catalog_menu_item.json'),
            'headers' => true
        ]);

        $items = $strategy->run();

        try {
            foreach ($items as $item) {
                MenuItem::updateOrCreate([
                    'catalog_menu_id' => $item['catalog_menu_id'],
                    'catalog_category_id' => $item['catalog_category_id']
                ], $item);
            }
        } catch (\Exception $e) {
        }
    }
}
