<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Catalog\Entities\OrderItem;
use Ignite\Core\Models\Grid\EloquentTable;
use Yajra\DataTables\DataTables;

class OrderItemTable extends EloquentTable
{
    /**
     * @var OrderItemFormatter
     */
    protected $formatter;

    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [];

    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        OrderItemFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'name' => 'actions',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '120px',
                'class' => 'actions'
            ],
            'image' => [
                'title' => 'Image',
                'name' => 'item.image',
                'orderable' => false,
                'exportable' => false,
                'searchable' => false,
                'visible' => true,
                'width' => '75px',
            ],
            'created_at' => [
                'title' => 'Created At',
                'name' => 'created_at',
                'orderable' => true,
                'exportable' => true,
                'visible' => true,
            ],
            'name' => [
                'title' => 'Name',
                'name' => 'name',
                'orderable' => true,
                'exportable' => true,
            ],
            'class' => [
                'title' => 'Classification',
                'name' => 'class',
                'orderable' => true,
                'exportable' => true,
            ],
            'cost' => [
                'title' => 'Cost',
                'name' => 'item.cost',
                'orderable' => true,
                'exportable' => true,
            ],
            'quantity' => [
                'title' => 'Quantity',
                'name' => 'item.quantity',
                'orderable' => true,
                'exportable' => true,
            ],
            'total' => [
                'title' => 'Total',
                'name' => 'total',
                'orderable' => false,
                'exportable' => true,
                'searchable' => false,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'status',
                'orderable' => true,
                'exportable' => true,
                'searchable' => false,
            ],
            'attempts' => [
                'title' => 'Attempts',
                'name' => 'attempts',
                'orderable' => false,
                'exportable' => true,
                'searchable' => false,
            ],
        ];
    }

    /**
     * The order items query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        $query = OrderItem::with(['order']);

        $query->where('catalog_order_id', $this->order->getKey());

        return $query;
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'image' => [$this->formatter, 'image'],
            'total' => [$this->formatter, 'total'],
            'status' => [$this->formatter, 'status'],
            'attempts' => [$this->formatter, 'attempts'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'] // Created At
        ]);
    }
}
