<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Catalog\Entities\Menu;
use Ignite\Core\Models\Grid\EloquentTable;
use Yajra\DataTables\DataTables;

class MenusTable extends EloquentTable
{
    /**
     * @var MenuFormatter
     */
    protected $formatter;

    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [];

    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        MenuFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title'          => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            'action' => [
                'name' => 'actions',
                'title' => trans('Core::core.common.actions'),
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => trans('Catalog::menu.fields.id.label'),
                'name' => 'catalog_menu.id',
                'orderable' => true,
                'exportable' => true,
            ],
            'name' => [
                'title' => trans('Catalog::menu.fields.name.label'),
                'name' => 'catalog_menu.label',
                'orderable' => true,
                'exportable' => true,
            ],
            'catalog_id' => [
                'title' => trans('Catalog::menu.fields.catalog.label'),
                'name' => 'catalog_menu.catalog_id',
                'orderable' => true,
                'exportable' => true,
            ],
            'active' => [
                'title' => trans('Catalog::menu.fields.active.label'),
                'name' => 'catalog_menu.active',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => 'Created At',
                'name' => trans('Catalog::menu.fields.created_at.label'),
                'orderable' => true,
                'exportable' => true,
                'visible' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return Menu::with('catalog');
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'checkbox' => [$this->formatter, 'checkbox'],
            'action' => [$this->formatter, 'actions'],
            'catalog_id' => [$this->formatter, 'catalog'],
            'active' => [$this->formatter, 'active'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'] // ID
        ], $this->getCheckboxColumnParameters());
    }
}
