<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Vendor;

class CatalogVendorTableSeeder extends AbstractCatalogSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('catalog_vendor.json')
        ]);

        $vendors = $strategy->run();

        foreach ($vendors as $vendor) {
            try {
                Vendor::create($vendor);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
