<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(\Ignite\Catalog\Entities\Item::class, function (\Faker\Generator $faker) {
    $name = $faker->sentence();
    return [
        'catalog_vendor_id' => null,
        'catalog_id' => null,
        'code' => str_slug($name, '-'),
        'sku' => str_slug($name, '_'),
        'name' => $name,
        'type' => 'simple',
        'class' => 'merchandise',
        'short_description' => $faker->paragraph(1),
        'description' => $faker->paragraph(),
        'terms' => $faker->paragraph(),
        'manufacturer' => 'Brightspot',
        'image' => 'brightspot.png',
        'msrp' => 100.0000,
        'cost' => 100.0000,
        'price' => 100.0000,
        'points' => 100.0000,
        'point_value' => 1,
        'price_markup' => 0.0000,
        'price_margin' => 0.0000,
        'visibility' => 1,
        'active' => 1,
        'vendor_active' => 0,
        'vendor_meta' => [],
        'created_at' => $faker->date('Y-m-d H:i:s'),
        'updated_at' => $faker->date('Y-m-d H:i:s'),
    ];
});
