<?php

namespace Ignite\Catalog\Models\Report;

use Ignite\Core\Entities\User;
use Ignite\Core\Models\Grid\QueryTable;

class OrderReport extends QueryTable
{
    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [
        'username', 'company'
    ];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [
        'user_id'
    ];

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'user_id' => [
                'title' => 'User ID',
                'name' => 'participant.user_id',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => 'Order Date',
                'name' => 'catalog_order.created_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'first' => [
                'title' => 'First',
                'name' => 'participant.first',
                'orderable' => true,
                'exportable' => true,
            ],
            'last' => [
                'title' => 'Last',
                'name' => 'participant.last',
                'orderable' => true,
                'exportable' => true,
            ],
            'email' => [
                'title' => 'E-mail',
                'name' => 'participant.email',
                'orderable' => true,
                'exportable' => true,
            ],
            'company' => [
                'title' => 'Company',
                'name' => 'participant.company',
                'orderable' => true,
                'exportable' => true,
            ],
            'number' => [
                'title' => 'Order #',
                'name' => 'catalog_order.number',
                'orderable' => true,
                'exportable' => true,
            ],
            'points' => [
                'title' => 'Points',
                'name' => 'catalog_order.points',
                'orderable' => true,
                'exportable' => true,
            ],
            'quantity' => [
                'title' => 'Quantity',
                'name' => 'catalog_order.quantity',
                'orderable' => true,
                'exportable' => true,
            ],
            'total' => [
                'title' => 'Total',
                'name' => 'total',
                'orderable' => true,
                'searchable' => false,
                'exportable' => true,
            ],
            'ssn' => [
                'title' => 'SSN',
                'name' => 'participant.ssn',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('total')
            ->keys()
            ->toArray();

        return $this->getConnection()->table('catalog_order')
            ->select($columns)
            ->addSelect($this->getConnection()->raw('(catalog_order.points * catalog_order.quantity) as total'))
            ->distinct()
            ->leftJoin('core_participant as participant', 'participant.user_id', '=', 'catalog_order.user_id')
            ->leftJoin('core_user as user', 'user.user_id', '=', 'participant.user_id')
            ->orderBy('catalog_order.created_at', 'desc')
            ->where('user.internal', User::TYPE_PARTICIPANT);
    }
}
