<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Illuminate\Database\Query\Builder;

class OrdersCancelledStat extends OrdersStat
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'type'  => 'metric',
            'label' => 'Orders cancelled',
            'link'  => url('/admin/catalog/orders/cancelled'),
        ], $attributes);

        parent::__construct($attributes);
    }


    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'orders-cancelled-stat';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * The query scoped for the metric type.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    protected function scope(Builder $query)
    {
        return $query->where('processed', '0')
            ->whereNotNull('cancelled_at');
    }
}
