<?php

namespace Ignite\Catalog\Tests\Unit\Models\Product\Classifications;

use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Models\Product\Classifications\Reloadable;
use Ignite\Catalog\Tests\TestCase;

class ReloadableTest extends TestCase
{
    /** @var Reloadable */
    protected $reloadable;

    public function setUp() : void
    {
        parent::setUp();

        $this->reloadable = new Reloadable(new Item());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_a_physical_product()
    {
        $this->assertTrue($this->reloadable->isPhysical());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_a_reloadable_product()
    {
        $this->assertTrue($this->reloadable->isReloadable());
    }

    /**
     * @test
     * @group Catalog
     * @group Product
     * @group Classifications
     */
    public function it_is_not_an_open_loop_product()
    {
        $this->assertTrue($this->reloadable->isOpenLoop());
    }
}
