<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Ignite\Core\Models\Dashboard\Table;
use Illuminate\Support\Fluent;

class MostPopularItemsTable extends Table
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label'   => 'Most popular items',
            'color'   => 'primary',
            'icon'    => 'ion ion-ios-shopping-bag',
            'link'    => url('/admin/catalog/items'),
            'sort'    => 3,
            'headers' => $this->getHeaders()
        ], $attributes);

        parent::__construct($attributes);
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'popular-items-list';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-12 col-sm-4');
    }

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData()
    {
        if (! $this->get('data', false)) {
            /**
             * @var Carbon $start
             * @var Carbon $end
             */
            list($start, $end) = $this->getDateRange();

            $this->attributes['data'] = $this->buildQuery($start, $end);
        }

        return $this->get('data');
    }

    /**
     * Build the query.
     *
     * @param Carbon $start
     * @param Carbon $end
     *
     * @return \Illuminate\Support\Collection
     */
    protected function buildQuery(Carbon $start, Carbon $end)
    {
        return DB::query()
            ->select(
                DB::raw('SUM(catalog_order_item.quantity) as total'),
                'catalog_order_item.catalog_item_id as item_id',
                DB::raw('IF(LEFT(catalog_item.image, 4) = "http", catalog_item.image, CONCAT(catalog_vendor.image_path, "/", catalog_item.image)) as `image`'),
                'catalog_order_item.name as name',
                DB::raw('LOWER(REPLACE(catalog_vendor.name, " ", "-")) as subtitle')
            )
            ->from('catalog_order_item')
            ->leftJoin('catalog_item', 'catalog_order_item.catalog_item_id', '=', 'catalog_item.id')
            ->leftJoin('catalog_vendor', 'catalog_order_item.catalog_vendor_id', '=', 'catalog_vendor.id')
            ->whereBetween('catalog_order_item.created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
            ->groupBy('catalog_order_item.catalog_item_id', 'catalog_order_item.name', 'catalog_vendor.image_path')
            ->orderBy('total', 'desc')
            ->take(10)
            ->get();
    }

    /**
     * The table headers, if any.
     *
     * @return array
     */
    public function getHeaders()
    {
        return [];
    }
}
