<?php

namespace Ignite\Catalog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Ignite\Catalog\Models\Cart;

class OrderCreateRequest extends FormRequest
{
    /**
     * Authorize the order create request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @param  Cart $cart
     * @return array
     */
    public function rules(Cart $cart)
    {
        $rules = [
            'first' => 'required',
            'last' => 'required',
            'ship_phone' => 'required'
        ];

        if ($cart->hasNonPhysical()) {
            $rules['ship_email'] = 'required|email';
        }

        if ($cart->hasPhysical()) {
            $rules['ship_address_1'] = 'required';
            $rules['ship_city'] = 'required';
            $rules['ship_state'] = 'required';
            $rules['ship_postal'] = 'required';
        }

        return $rules;
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'first.required' => __('Catalog::theme.order.validation.first.required'),
            'last.required'  => __('Catalog::theme.order.validation.last.required'),
            'email.required'  => __('Catalog::theme.order.validation.email.required'),
            'email.email'  => __('Catalog::theme.order.validation.email.email'),
            'ship_phone.required'  => __('Catalog::theme.order.validation.ship_phone.required'),
            'ship_phone.numeric'  => __('Catalog::theme.order.validation.ship_phone.required'),
            'ship_address_1.required'  => __('Catalog::theme.order.validation.ship_address_1.required'),
            'ship_address_2.required'  => __('Catalog::theme.order.validation.ship_address_2.required'),
            'ship_city.required'  => __('Catalog::theme.order.validation.ship_city.required'),
            'ship_state.required'  => __('Catalog::theme.order.validation.ship_state.required'),
            'ship_postal.required'  => __('Catalog::theme.order.validation.ship_postal.required'),
        ];
    }
}
