<?php

namespace Ignite\Catalog\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class OrderForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $this->add('ship_name', 'text', $this->getShipNameOptions());
        $this->add('ship_email', 'text', $this->getShipEmailOptions());
        $this->add('ship_phone', 'text', $this->getShipPhoneOptions());
        $this->add('ship_address_1', 'text', $this->getShipAddress1Options());
        $this->add('ship_address_2', 'text', $this->getShipAddress2Options());
        $this->add('ship_address_3', 'text', $this->getShipAddress3Options());
        $this->add('ship_city', 'text', $this->getShipCityOptions());
        $this->add('ship_state', 'text', $this->getShipStateOptions());
        $this->add('ship_postal', 'text', $this->getShipPostalOptions());
        $this->add('ship_country', 'text', $this->getShipCountryOptions());
        $this->add('submit', 'submit', $this->getSaveButtonOptions());

        return $this;
    }

    /**
     * The options for the shipping name field.
     *
     * @return array
     */
    protected function getShipNameOptions()
    {
        return [
            'rules' => 'required|min:2|max:255',
            'label' => trans('Catalog::order.fields.ship_name.label'),
        ];
    }

    /**
     * The options for the shipping email field.
     *
     * @return array
     */
    protected function getShipEmailOptions()
    {
        return [
            'rules' => 'required|max:255|email',
            'label' => trans('Catalog::order.fields.ship_email.label'),
        ];
    }

    /**
     * The options for the phone field.
     *
     * @return array
     */
    protected function getShipPhoneOptions()
    {
        return [
            'rules' => 'required|max:255',
            'label' => trans('Catalog::order.fields.ship_phone.label'),
        ];
    }

    /**
     * The options for the ship address 1 field.
     *
     * @return array
     */
    protected function getShipAddress1Options()
    {
        return [
            'rules' => 'required|max:255',
            'label' => trans('Catalog::order.fields.ship_address_1.label'),
        ];
    }

    /**
     * The options for the ship address 1 field.
     *
     * @return array
     */
    protected function getShipAddress2Options()
    {
        return [
            'rules' => 'max:255',
            'label' => trans('Catalog::order.fields.ship_address_2.label'),
        ];
    }

    /**
     * The options for the ship address 1 field.
     *
     * @return array
     */
    protected function getShipAddress3Options()
    {
        return [
            'rules' => 'max:255',
            'label' => trans('Catalog::order.fields.ship_address_3.label'),
        ];
    }

    /**
     * The options for the ship city field.
     *
     * @return array
     */
    protected function getShipCityOptions()
    {
        return [
            'rules' => 'required|max:255',
            'label' => trans('Catalog::order.fields.ship_city.label'),
        ];
    }

    /**
     * The options for the ship state field.
     *
     * @return array
     */
    protected function getShipStateOptions()
    {
        return [
            'rules' => 'required|max:255',
            'label' => trans('Catalog::order.fields.ship_state.label'),
        ];
    }

    /**
     * The options for the ship postal field.
     *
     * @return array
     */
    protected function getShipPostalOptions()
    {
        return [
            'rules' => 'required|max:255',
            'label' => trans('Catalog::order.fields.ship_postal.label'),
        ];
    }

    /**
     * The options for the ship country field.
     *
     * @return array
     */
    protected function getShipCountryOptions()
    {
        return [
            'rules' => 'required|max:255',
            'label' => trans('Catalog::order.fields.ship_country.label'),
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getSaveButtonOptions()
    {
        return [
            'attr' => ['class' => 'btn btn-primary'],
            'label' => trans('Catalog::order.fields.save.label')
        ];
    }
}
