<?php

return [
    'name' => 'Catalog',

    'disk' => 's3',

    /**
     * When there is only one active catalog in the database, should we redirect to that one directly? Or display the
     * catalog index page and ask the user to click on the catalog?
     */
    'redirect_when_only_one' => false,

    /**
     * On the catalog vendor index page and item page, should we display the type of item e.g. giftcard, egift etc
     * as a 'ribbon' on the item image?
     */
    'display_type_ribbon' => false,

    /**
     * The default global point value conversion rate. Point value can also be changed per item.
     */
    'default_point_value' => '0.05',

    /**
     * The default global price margin. Price margin can also be changed per item.
     */
    'default_price_margin' => '13.04',

    'order' => [
        'prefix' => env('CATALOG_ORDER_PREFIX', 'IG'),
        'padding' => env('CATALOG_ORDER_PADDING', 10)
    ],

    'vendors' => [
        'hawk' => [
            'merchant_id' => env('CATALOG_HAWK_MERCHANT_ID'),
            'cert' => base_path(env('CATALOG_HAWK_CERT')),
            'key' => base_path(env('CATALOG_HAWK_KEY')),
            'prepaid' => [
                'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_PREPAID_TEST_ID', '43476908'),
                'payment_type' => env('CATALOG_HAWK_PREPAID_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'tax_id' => env('CATALOG_HAWK_PREPAID_TAX_ID'),
                'description' => env('CATALOG_HAWK_PREPAID_DESCRIPTION', ''),
                'fourth_line_emboss' => env('CATALOG_HAWK_PREPAID_FOURTH_LINE_EMBOSS', 'THANK YOU'),
                'card_carrier_message' => env('CATALOG_HAWK_PREPAID_CARD_CARRIER_MESSAGE', ''),
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_STANDARD_MAIL),
            ],
            'reloadable' => [
                'enabled' => env('CATALOG_HAWK_RELOADABLE_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_RELOADABLE_TEST_ID', '43531408'),
                'payment_type' => env('CATALOG_HAWK_RELOADABLE_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'description' => env('CATALOG_HAWK_RELOADABLE_DESCRIPTION', ''),
                'fourth_line_emboss' => env('CATALOG_HAWK_RELOADABLE_FOURTH_LINE_EMBOSS', 'THANK YOU'),
                'card_carrier_message' => env('CATALOG_HAWK_RELOADABLE_CARD_CARRIER_MESSAGE', ''),
                'shipping_method' => env('CATALOG_HAWK_RELOADABLE_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_STANDARD_MAIL),
                'identity_column' => 'user_id',
                'pid_column' => 'reloadable_pid',
            ],
            'giftcard' => [
                'enabled' => env('CATALOG_HAWK_GIFTCARD_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_GIFTCARD_TEST_ID', '43507508'),
                'payment_type' => env('CATALOG_HAWK_GIFTCARD_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT)
            ],
            'egift' => [
                'enabled' => env('CATALOG_HAWK_EGIFT_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_EGIFT_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_EGIFT_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - eGift Order',
                'emailMessage' => env('CATALOG_HAWK_EGIFT_MESSAGE', ''),
                'emailClosingName' => 'Reward Headquarters',
            ],
            'company' => 'Ignite Catalog Rewards',
            'contact' => 'IT Staff',
            'address1' => '102 Decker Ct Suite 150',
            'city' => 'Irving',
            'state' => 'TX',
            'zip' => '75062',
            'country' => 'US',
            'unsubscribe' => [
                'type' => 'EMAIL',
                'value' => 'it@brightspot.email'
            ],
            'schema' => [
                [
                    'name' => 'product_id',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Product ID'
                ], [
                    'name' => 'content_provider_code',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Content Provider Code'
                ], /*[
                    'name' => 'payment_type',
                    'type' => 'select',
                    'rules' => 'required',
                    'label' => 'Payment Type',
                    'choices' => [
                        '' => 'Please choose a payment type',
                        Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT => 'ACH DEBIT',
                        Ignite\Vendor\Hawk\PaymentType::ACH_CREDIT => 'ACH CREDIT',
                        Ignite\Vendor\Hawk\PaymentType::CREDIT_CARD => 'CREDIT CARD',
                        Ignite\Vendor\Hawk\PaymentType::WIRE_TRANSFER => 'WIRE TRANSFER',
                        Ignite\Vendor\Hawk\PaymentType::DRAW_DOWN => 'DRAW DOWN',
                        Ignite\Vendor\Hawk\PaymentType::BUSINESS_CHECK => 'BUSINESS CHECK',
                        Ignite\Vendor\Hawk\PaymentType::POST_PAY => 'POST PAY',
                    ]
                ]*/
            ]
        ],

        'brightspot' => [
            "name" => "brightspot",
            "type" => "merchandise",
            "image_path" => "catalog/brightspot",
            "vendor_countries" => "US",
            "redemption_class" => Ignite\Catalog\Vendors\NullProcessor::class,
            "active" => 1
        ]
    ],

    'brightspot' => [
        "name" => "International Merchandise Catalog",
        "code" => "brightspot",
        "type" => "merchandise",
        "description" => "Example International merchandise catalog.",
        "countries" => "US",
        "active" => 1,
    ],

    'product' => [
        'types' => [
            'merchandise' => Ignite\Catalog\Models\Product\Classifications\Merchandise::class,
            'giftcard' => Ignite\Catalog\Models\Product\Classifications\Card::class,
            'egift' => Ignite\Catalog\Models\Product\Classifications\Egift::class,
            'prepaid' => Ignite\Catalog\Models\Product\Classifications\Prepaid::class,
            'reloadable' => Ignite\Catalog\Models\Product\Classifications\Reloadable::class,
        ]
    ],

    'report' => [
        'filters' => [
            Ignite\Catalog\Models\Report\OrderReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'label' => 'Order Date',
                    'field' => 'catalog_order.created_at',
                    'options' => []
                ]
            ],
            Ignite\Catalog\Models\Report\OrderItemReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'label' => 'Order Date',
                    'field' => 'catalog_order_item.created_at',
                    'options' => []
                ]
            ]
        ]
    ]
];
