<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Category;

class CatalogCategoryTableSeeder extends AbstractCatalogSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('catalog_category.json'),
            'headers' => true
        ]);

        $categories = $strategy->run();

        try {
            foreach ($categories as $category) {
                Category::updateOrCreate([
                    'code' => $category['code']
                ], $category);
            }
        } catch (\Exception $e) {
        }
    }
}
