<?php

namespace Ignite\Catalog\Events\Handlers\Menus;

use Ignite\Core\Contracts\CanDisplayInMenu;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Events\Menus\ActionMenuPreCompile;
use Nwidart\Modules\Laravel\LaravelFileRepository as ModuleRepository;

class AddCatalogToParticipantActionMenu
{
    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * AddCatalogItemsToNavigationMenu constructor.
     *
     * @param ModuleRepository $moduleRepository
     */
    public function __construct(ModuleRepository $moduleRepository)
    {
        $this->moduleRepository = $moduleRepository;
    }

    /**
     * Handle the event.
     *
     * @param ActionMenuPreCompile $event
     */
    public function handle(ActionMenuPreCompile $event)
    {
        if ($this->moduleRepository->isDisabled('Catalog')) {
            return;
        }

        $context = $event->getContext();

        if (! isset($context['model']) || $context['model'] !== Participant::class) {
            return;
        }

        if (! isset($context['primaryKey']) || empty($context['model'])) {
            return;
        }

        foreach ($this->getItems($event->getContext()) as $item) {
            $action = $event->getManager()->hydrateItem($item);

            if ($action instanceof CanDisplayInMenu) {
                $event->getManager()->getItems()->first()->addChild($action);
            }
        }
    }

    /**
     * Get the items to merge with the menu.
     *
     * @param  array $context
     * @return \Illuminate\Support\Collection
     */
    protected function getItems(array $context)
    {
        return collect([
            [
                'position' => 40,
                'url' => route('admin.participant.orders', [$context['primaryKey']]),
                'label' => 'View Orders',
                'icon' => 'shopping-basket',
                'allow' => auth()->user()->can('catalog.order.browse')
            ],
        ]);
    }
}
