<?php

namespace Ignite\Catalog\Providers;

use Ignite\Catalog\Events\Handlers\Menus\AddCatalogMenu;
use Ignite\Catalog\Events\Handlers\Menus\AddCatalogToParticipantActionMenu;
use Ignite\Catalog\Events\Handlers\Menus\AddCatalogToParticipantPanel;
use Ignite\Catalog\Events\Handlers\Participants\DeleteCatalogRelationsWhenDeletingParticipant;
use Ignite\Catalog\Events\IncompleteHawkOrder;
use Ignite\Catalog\Events\Subscribers\OrderEventSubscriber;
use Ignite\Catalog\Events\Handlers\Menus\AddCatalogItemsToNavigationMenu;
use Ignite\Catalog\Listeners\RequestHawkOrderInfo;
use Ignite\Core\Events\EnrollmentDeleting;
use Ignite\Core\Events\Menus\ActionMenuPreCompile;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\ParticipantMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        NavigationMenuPreCompile::class => [
            AddCatalogItemsToNavigationMenu::class
        ],
        UserMenuPreCompile::class => [
            AddCatalogItemsToNavigationMenu::class
        ],
        AdminMenuPreCompile::class => [
            AddCatalogMenu::class
        ],
        ParticipantMenuPreCompile::class => [
            AddCatalogToParticipantPanel::class
        ],
        ActionMenuPreCompile::class => [
            AddCatalogToParticipantActionMenu::class
        ],
        EnrollmentDeleting::class => [
            DeleteCatalogRelationsWhenDeletingParticipant::class
        ],
        IncompleteHawkOrder::class => [
            RequestHawkOrderInfo::class
        ]
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [
        OrderEventSubscriber::class,
    ];
}
