<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Illuminate\Database\Query\Builder;

class OrdersProcessingStat extends OrdersStat
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Orders processing',
            'color' => 'yellow',
            'link'  => url('/admin/catalog/orders/processing'),
            'sort'  => 2,
            'type'  => 'metric'
        ], $attributes);

        parent::__construct($attributes);
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'orders-processing-correlated-stat';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * The query scoped for the metric type.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    protected function scope($query)
    {
        return $query->whereNull('cancelled_at')
             ->where('processed', 0);
    }
}
