<?php

namespace Ignite\Catalog\Collections;

use Ignite\Catalog\Entities\OrderItem;
use Illuminate\Database\Eloquent\Collection;

/**
 * @see \Ignite\Catalog\Entities\OrderItem
 */
class OrderItemCollection extends Collection
{
    /**
     * Count the number of processed order items in the collection.
     *
     * @return OrderItemCollection
     */
    public function processed()
    {
        return $this->filter(function (OrderItem $orderItem) {
            return $orderItem->isProcessed();
        });
    }

    /**
     * Count the number of processing order items in the collection.
     *
     * @return OrderItemCollection
     */
    public function processing()
    {
        return $this->filter(function (OrderItem $orderItem) {
            return $orderItem->isProcessing();
        });
    }

    /**
     * Count the number of cancelled order items in the collection.
     *
     * @return OrderItemCollection
     */
    public function cancelled()
    {
        return $this->filter(function (OrderItem $orderItem) {
            return $orderItem->isCancelled();
        });
    }
}
