<?php

namespace Ignite\Catalog\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\NavigationMenu;
use Nwidart\Modules\Laravel\LaravelFileRepository as ModuleRepository;

class AddCatalogItemsToNavigationMenu
{
    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * AddCatalogItemsToNavigationMenu constructor.
     *
     * @param ModuleRepository $moduleRepository
     */
    public function __construct(ModuleRepository $moduleRepository)
    {
        $this->moduleRepository = $moduleRepository;
    }

    /**
     * Handle the event.
     *
     * @param NavigationMenuPreCompile|UserMenuPreCompile $event
     * @throws \Nwidart\Modules\Exceptions\ModuleNotFoundException
     */
    public function handle($event)
    {
        if ($this->moduleRepository->isDisabled('Catalog')) {
            return;
        }

        /** @var NavigationMenu $manager */
        $manager = $event->getManager();

        $item = new Item(url('/catalog/order'), 'My Orders', 40);

        if ($manager->has('/participant/profile') && $event instanceof NavigationMenuPreCompile) {
            $manager->add(new Item('/catalog', 'Catalog', 40));
            $manager->get('/participant/profile')->addChild($item);
        }

        if ($event instanceof UserMenuPreCompile) {
            $manager->add($item);
        }
    }
}
