<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Ignite\Core\Entities\User;

/**
 * Cart Item Entity
 *
 * @property int id
 * @property int user_id
 * @property int item_id
 * @property int super_id
 */
class Favorite extends Model
{
    /** @var string */
    protected $primaryKey = 'id';

    /** @var string */
    protected $table = 'catalog_favorite';

    /**
     * @var array
     */
    protected $guarded = array();

    /**
     * The relationship to the catalog item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function item()
    {
        return $this->hasOne(Item::class, 'id', 'item_id');
    }

    /**
     * The relationship to the user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function user()
    {
        return $this->hasOne(User::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to the user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function super()
    {
        return $this->hasOne(Item::class, 'id', 'super_id');
    }

    /**
     * Scope a query by attaching a user.
     *
     * @param  Builder  $query
     * @param  User|int $user
     * @return Builder
     */
    public function scopeByUser(Builder $query, $user)
    {
        $user = ($user instanceof User) ? $user->getKey() : $user;
        $query->where('user_id', $user);

        return $query;
    }

    /**
     * Scope a query by attaching the current user.
     *
     * @param  Builder $query
     * @return Builder
     */
    public function scopeByCurrentUser(Builder $query)
    {
        $query->where('user_id', auth()->user()->getKey());

        return $query;
    }

    /**
     * Scope a query by attaching the catalog item.
     *
     * @param  Builder  $query
     * @param  Item|int $item
     * @return Builder
     */
    public function scopeForItem(Builder $query, $item)
    {
        $item = ($item instanceof Item) ? $item->getKey() : $item;
        $query->where('item_id', $item);

        return $query;
    }

    /**
     * Scope a query by attaching the catalog items.
     *
     * @param  Builder $query
     * @param  array   $items
     * @return Builder
     */
    public function scopeForItems(Builder $query, array $items)
    {
        $query->whereIn('item_id', $items);

        return $query;
    }
}
