<?php

namespace Ignite\Catalog\Contracts;

use Ignite\Catalog\Entities\Item;
use Ignite\Core\Entities\User;

interface FavoriteRepository
{
    /**
     * Paginate the favorited items for the given user
     *
     * @param  int $perPage
     * @param  User|null $user
     * @return \Illuminate\Pagination\LengthAwarePaginator
     */
    public function paginate($perPage = 25, User $user = null);

    /**
     * Find all favorited items for a single user.
     *
     * @param  User|null $user
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findByUser(User $user = null);

    /**
     * Find a favorite by id.
     *
     * @param int       $id
     * @param string    $column
     * @param User|null $user
     * @return \Ignite\Catalog\Entities\Favorite
     */
    public function find($id, $column = 'id', User $user = null);

    /**
     * Mark an item as a favorite.
     *
     * @param Item      $item
     * @param User|null $user
     * @return \Ignite\Catalog\Entities\Favorite
     */
    public function favorite(Item $item, User $user = null);

    /**
     * Un-mark an item as a favorite.
     *
     * @param Item      $item
     * @param User|null $user
     * @return \Ignite\Catalog\Entities\Favorite
     */
    public function unfavorite(Item $item, User $user = null);

    /**
     * Count the number of favorited items for a user.
     *
     * @param  User|null $user
     * @return int
     */
    public function count(User $user = null);
}
