<?php

namespace Ignite\Catalog\Contracts;

interface CatalogItemRepository
{
    /**
     * The base query builder.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find an Item by id.
     *
     * @param  int $id
     * @return \Ignite\Catalog\Entities\Item
     */
    public function find($id);

    /**
     * Find catalog items by catalog.
     *
     * @param  \Ignite\Catalog\Entities\Catalog $catalog
     * @return \Illuminate\Support\Collection
     */
    public function findByCatalog($catalog);

    /**
     * Find all catalog items.
     *
     * @return \Illuminate\Support\Collection
     */
    public function findAll();

    /**
     * Paginate catalog items.
     *
     * @param  int $records
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function paginate($records = 25);

    /**
     * Create a new catalog item.
     *
     * @param  array $data
     * @return \Ignite\Catalog\Entities\Item
     */
    public function create($data);

    /**
     * Update an existing catalog item.
     *
     * @param  int    $id
     * @param  array  $data
     * @return \Ignite\Catalog\Entities\Item
     */
    public function update($id, $data);

    /**
     * Enable a catalog item.
     *
     * @param  int $id
     * @return bool
     */
    public function enable($id);

    /**
     * Disable a catalog item.
     *
     * @param  int $id
     * @return bool
     */
    public function disable($id);

    /**
     * Delete the records with the given IDs.
     *
     * @param  string|array $ids
     * @return bool
     */
    public function delete($ids);
}
