<?php

namespace Ignite\Catalog\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class MenuForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $this->add('name', 'text', $this->getNameOptions());
        $this->add('catalog_id', 'select', $this->getCatalogOptions());
        $this->add('active', 'toggle', $this->getActiveOptions());
        $this->add('items', 'hidden', $this->getItemsOptions());
        $this->add('submit', 'submit', $this->getSaveButtonOptions());

        return $this;
    }

    /**
     * The options for the name field.
     *
     * @return array
     */
    protected function getNameOptions()
    {
        return [
            'rules' => 'required|min:2|max:255',
            'label' => trans('Catalog::menu.fields.name.label'),
        ];
    }

    /**
     * The options for the catalog field.
     *
     * @return array
     */
    protected function getCatalogOptions()
    {
        return [
            'attr' => ['class' => 'form-control select2'],
            'rules' => 'required|max:255',
            'label' => trans('Catalog::menu.fields.catalog.label'),
            'choices' => app(\Ignite\Catalog\Models\Options\Catalog::class)->toDropdown(),
        ];
    }

    /**
     * The options for the active field.
     *
     * @return array
     */
    protected function getActiveOptions()
    {
        return [
            'label' => trans('Catalog::menu.fields.active.label')
        ];
    }

    /**
     * The options for the items field.
     *
     * @return array
     */
    protected function getItemsOptions()
    {
        return [
            'attr' => [
                'id' => 'associated'
            ]
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getSaveButtonOptions()
    {
        return [
            'attr' => ['class' => 'btn btn-primary'],
            'label' => trans('Catalog::menu.fields.save.label')
        ];
    }
}
