window.Vue = require('vue');
window.axios = require('axios');
window.axios.defaults.headers.common = {
  //'X-CSRF-TOKEN': window.Laravel.csrfToken,
  'X-Requested-With': 'XMLHttpRequest'
};

Vue.component('catalog-attributes', require('./components/CatalogAttributes.vue'));

const app = new Vue({
  el: '#catalog-attributes',
  methods: {
    updateHiddenField: function(payload) {
      var element = document.getElementById('catalog-attributes-value');
      var attributes = {};

      for (var i in payload) {
        if (payload.hasOwnProperty(i)) {
          var variant = payload[i];
          attributes[variant.attribute.id] = this.formatOptions(variant.options);
        }
      }

      element.value = JSON.stringify(attributes);
    },
    formatOptions: function(input) {
      var options = [];
      for (var i in input) {
        if (input.hasOwnProperty(i)) {
          options.push(this.formatOption(input[i]));
        }
      }
      return options;
    },
    formatOption: function(option) {
      return {
        id: option.id,
        attribute_id: option.attribute_id,
        item_id: option.item_id,
        super_id: option.super_id,
        position: option.position,
        label: option.label,
        value: option.value
      };
    }
  }
});
