<?php

namespace Ignite\Catalog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CartItemUpdateRequest extends FormRequest
{
    /**
     * Authorize the order create request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return  [
            'items.*.class' => 'required',
            'items.*.quantity' => 'required|numeric|max:30',
        ];
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'items.*.class.required' => 'The item class is required',
            'items.*.quantity.required' => 'The item quantity is required',
            'items.*.quantity.numeric' => 'The item quantity must be numeric',
            'items.*.quantity.max' => 'The maximum quantity per item is 30',
        ];
    }
}
