<?php

namespace Ignite\Catalog\Events;

use Illuminate\Queue\SerializesModels;
use Ignite\Catalog\Entities\Order;

class OrderEvent
{
    use SerializesModels;

    public $order;

    /**
     * Create a new event instance.
     *
     * @param Order $order
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
