<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk\Response;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Ignite\Catalog\Models\Hawk\Response\SubmitClosedLoopAnonymousResponse;
use Ignite\Tests\TestCase;
use Psr\Http\Message\ResponseInterface;

class SubmitClosedLoopAnonymousResponseTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @var array
     */
    protected $data = [
        'transactionId' => 'XH012K7LX24',
        'orderNumber' =>  '100000102131',
        'isCompleted' => true,
        'percentComplete' =>  100,
        'success' =>  true,
    ];

    /**
     * Set up the test.
     *
     * @return void
     */
    public function setUp() : void
    {
        parent::setUp();
    }

    /**
     * Tear down the test.
     *
     * @return void
     */
    public function tearDown()
    {
        //$this->resetDatabase();
        parent::tearDown();
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_transform_response_body_into_an_instance()
    {
        $mock = \Mockery::mock(ResponseInterface::class);
        $mock->shouldReceive('getBody')->andReturn(json_encode($this->data));

        $response = SubmitClosedLoopAnonymousResponse::fromHttpResponse($mock);

        $this->assertSame($this->data, $response->toArray());
        $this->assertEquals($this->data['transactionId'], $response->getTransactionId());
        $this->assertEquals($this->data['orderNumber'], $response->getOrderNumber());
        $this->assertEquals($this->data['percentComplete'], $response->getPercentComplete());
        $this->assertEquals($this->data['isCompleted'], $response->getIsCompleted());
        $this->assertEquals($this->data['success'], $response->getSuccess());
    }
}
