<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Illuminate\Database\Query\Builder;

class OrdersProcessedStat extends OrdersStat
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Orders processed',
            'type'  => 'metric',
            'link'  => url('/admin/catalog/orders/processed'),
        ], $attributes);

        parent::__construct($attributes);
    }


    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'orders-processed-stat';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }
    /**
     * The query scoped for the metric type.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    protected function scope(Builder $query)
    {
        return $query->where('processed', '=', '1')
            ->whereNull('cancelled_at');
    }
}
