<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk\Response;

use Ignite\Catalog\Models\Hawk\EGiftIndividualOrderLine;
use Ignite\Catalog\Models\Hawk\EmailContent;
use Ignite\Catalog\Models\Hawk\PaymentType;
use Ignite\Catalog\Models\Hawk\Request\SubmitEGiftIndividualRequest;
use Ignite\Tests\TestCase;

class SubmitEGiftIndividualRequestTest extends TestCase
{
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_provides_the_correct_array_data_for_request()
    {
        $input = [
            'orderDetails' => [
                EGiftIndividualOrderLine::fromAssociativeArray([
                    'amount' => 25,
                    'contentProvider' => 'Target_eGift',
                    'recipient' => [
                        'firstName' => 'John',
                        'lastName' => 'Smith',
                        'email' => 'johnsmith@gmail.com'
                    ]
                ])
            ],
            'clientProgramNumber'=> '123123123',
            'emailContent' => EmailContent::fromAssociativeArray([
                'senderName' => 'Ignite Platform',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Test eGift Subject',
                'emailMessage' => 'Test eGift Message',
                'emailClosingName' => 'Test eGift Closing Name',
                'unsubscribeData' => [
                    'companyName' => 'Brightspot',
                    'addressLine1' => '102 Decker Court',
                    'addressCity' => 'Irving',
                    'addressState' => 'TX',
                    'addressZip' => '75062',
                    'addressCountry' => 'US',
                    'methodType' => 'EMAIL',
                    'value' => 'it@brightspot.email',
                ]
            ]),
            'paymentType' => PaymentType::DRAW_DOWN,
        ];

        $request = new SubmitEGiftIndividualRequest(
            $input['orderDetails'],
            $input['clientProgramNumber'],
            $input['emailContent'],
            $input['paymentType']
        );

        $output = $request->toArray();

        $this->assertInternalType('array', $output['orderDetails']);
        $this->assertNotEmpty($output['orderDetails']);
        $this->assertSame('123123123', $output['clientProgramNumber']);
        $this->assertSame(PaymentType::DRAW_DOWN, $output['paymentType']);
        $this->assertSame('Target_eGift', $output['orderDetails'][0]['contentProvider']);
    }
}
