<?php

namespace Ignite\Catalog\Contracts;

use Illuminate\Support\Collection;

interface MenuRepository
{
    /**
     * The default query builder.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find a menu by id.
     *
     * @param  int  $id
     * @return \Ignite\Catalog\Entities\Menu
     */
    public function find($id);

    /**
     * Create a menu.
     *
     * @param  Collection  $data
     * @return \Ignite\Catalog\Entities\Menu
     */
    public function create(Collection $data);

    /**
     * Update a menu.
     *
     * @param  int  $id
     * @param  Collection  $data
     * @return \Ignite\Catalog\Entities\Menu
     */
    public function update(int $id, Collection $data);

    /**
     * Delete a menu and any associated data.
     *
     * @param  int  $id
     * @return bool
     */
    public function delete(int $id);

    /**
     * Delete many menus and any associated data.
     *
     * @param  array  $ids
     * @return array
     */
    public function deleteMany(array $ids);
}
