<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Core\Entities\Permission;

class PermissionTableSeeder extends AbstractCatalogSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        app('authorization')->forgetCachedPermissions();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('permission.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Permission::updateOrCreate(['key' => $source['key']], $source);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
