<?php

namespace Ignite\Catalog\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class OrderItemChangeStatusForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $quantity = $this->getData('quantity');
        $this->add('quantity', 'number', [
            'label' => 'Quantity',
            'rules' => 'required|numeric',
            'attr' => [
                'max' => $quantity,
                'min' => 0,
                'step' => 1
            ]
        ]);

        $status = $this->getData('status', null);
        if ($status === 'processed') {
            $this->add('number', 'text', [
                'label' => 'Order #',
                'rules' => 'required'
            ]);
        }

        $this->add('date', 'text', [
            'label' => 'Date',
            'rules' => 'date',
            'attr' => [
                'class' => 'form-control datepicker'
            ],
            'default_value' => now()->format('m/d/Y')
        ]);

        $this->add('notes', 'textarea', [
            'label' => 'Notes',
            'rules' => 'max:200',
            'attr' => [
                'style' => 'height: 150px; min-height: 75px'
            ],
        ]);

        $this->add('submit', 'submit', [
            'label' => 'Save',
            'attr' => ['class' => 'btn btn-primary'],
        ]);

        return $this;
    }
}
