<?php

namespace Ignite\Catalog\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Ignite\Catalog\Entities\Order;
use Ignite\Core\Entities\User;

class OrderSubmitted extends Mailable
{
    use Queueable, SerializesModels;

    /** @var Order */
    private $order;

    /**
     * Create a new order submitted message instance.
     *
     * @param Order $order
     */
    public function __construct($order)
    {
        $this->order = $order;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if (! $this->order->relationLoaded('items')) {
            $this->order->load('items');
        }

        if (! $this->order->relationLoaded('participant')) {
            $this->order->load('participant');
        }

        $data = [
            'first_name' => $this->order->participant->first,
            'last_name' => $this->order->participant->last,
            'email' => $this->order->participant->email,
            'order' => $this->order,
        ];

        $this->to($this->order->participant->email, $this->order->participant->fullName());
        $this->subject("Order Confirmation #{$this->order->number}");
        $this->from(config('mail.from.address'), config('mail.from.name'));
        $this->bcc(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown('emails.orders.submitted', $data);
    }
}
