<?php

namespace Ignite\Catalog\Vendors;

use Illuminate\Support\Collection;
use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\OrderItem;

trait DispatchesOrderItems
{
    /**
     * Handle dispatch order items.
     *
     * @param  Collection $orderItems
     * @param  Order      $order
     * @param  string     $className
     * @return Collection
     */
    public function dispatchOrderItems(Collection $orderItems, Order $order, $className)
    {
        return $orderItems->filter->isVendorActive()->values()
            ->each(function (OrderItem $orderItem, $count) use ($order, $className) {
                dispatch(new $className($order, $orderItem))->delay($count + 1);
            });
    }
}
