<?php

if (\Nwidart\Modules\Facades\Module::disabled('Catalog')) {
    return;
}

// Catalog Pages Routes
Route::group([
    'middleware' => ['web', 'auth'],
    'prefix' => '/catalog'
], function () {
    Route::get('/', 'CatalogController@index')->name('catalog.index');

    Route::get('/item/{item}', 'ItemController@show')->name('catalog.item.show');

    Route::get('/cart', 'CartController@index')->name('catalog.cart.index');
    Route::post('/cart', 'CartController@store')->name('catalog.cart.store');
    Route::put('/cart', 'CartController@update')->name('catalog.cart.update');
    Route::delete('/cart/{item?}', 'CartController@destroy')->name('catalog.cart.destroy');

    Route::get('/favorites', 'FavoritesController@index')->name('catalog.favorites.index');
    Route::any('/favorites/{item}/store', 'FavoritesController@store')->name('catalog.favorites.store');
    Route::any('/favorites/{item?}/delete', 'FavoritesController@destroy')->name('catalog.favorites.destroy');

    Route::get('/checkout', 'CheckoutController@create')->name('catalog.checkout.create');
    Route::post('/checkout', 'CheckoutController@store')->name('catalog.checkout.store');
    Route::get('/checkout/{number}', 'CheckoutController@show')->name('catalog.checkout.show');

    Route::get('/order', 'OrderController@index')->name('catalog.order.index');
    Route::get('/order/{number}', 'OrderController@show')->name('catalog.order.show');

    Route::any('/{catalog}', 'CatalogController@show')->name('catalog.show');
});

// Catalog Admin Pages Routes
Route::group([
    'middleware' => ['web', 'auth'],
    'namespace' => 'Admin',
    'prefix' => '/admin/participant'
], function () {
    Route::any('/participants/{participant}/orders', 'ParticipantOrdersController@index')->name('admin.participant.orders');
});

// Catalog Admin Pages Routes
Route::group([
    'middleware' => ['web', 'auth'],
    'namespace' => 'Admin',
    'prefix' => '/admin/catalog'
], function () {
    // Catalog Admin
    Route::any('/catalog', 'CatalogController@index')->name('admin.catalog.index');
    Route::any('/catalog/export', 'CatalogController@index')->name('admin.catalog.index.export');
    Route::any('/catalog/show/{catalog}', 'CatalogController@show')->name('admin.catalog.show');
    Route::get('/catalog/create', 'CatalogController@create')->name('admin.catalog.create');
    Route::post('/catalog/store', 'CatalogController@store')->name('admin.catalog.store');
    Route::get('/catalog/edit/{catalog}', 'CatalogController@edit')->name('admin.catalog.edit');
    Route::post('/catalog/update/{id}', 'CatalogController@update')->name('admin.catalog.update');
    Route::delete('/catalog/delete', 'CatalogController@destroyMany')->name('admin.catalog.destroyMany');
    Route::delete('/catalog/delete/{id}', 'CatalogController@destroy')->name('admin.catalog.destroy');

    // Catalog Categories Admin
    Route::any('/categories', 'CategoriesController@index')->name('admin.catalog.categories.index');
    Route::any('/categories/export', 'CategoriesController@index')->name('admin.catalog.categories.index.export');
    Route::get('/categories/create', 'CategoriesController@create')->name('admin.catalog.categories.create');
    Route::post('/categories/create', 'CategoriesController@store')->name('admin.catalog.categories.store');
    Route::get('/categories/{category}', 'CategoriesController@show')->name('admin.catalog.categories.show');
    Route::get('/categories/{category}/edit', 'CategoriesController@edit')->name('admin.catalog.categories.edit');
    Route::post('/categories/{category}/edit', 'CategoriesController@update')->name('admin.catalog.categories.update');
    Route::delete('/categories/delete', 'CategoriesController@destroyMany')->name('admin.catalog.categories.destroyMany');
    Route::delete('/categories/delete/{category}', 'CategoriesController@destroy')->name('admin.catalog.categories.destroy');

    // Catalog Attributes Admin
    Route::any('/attributes', 'AttributesController@index')->name('admin.catalog.attributes.index');
    Route::any('/attributes/export', 'AttributesController@index')->name('admin.catalog.attributes.index.export');
    Route::get('/attributes/create', 'AttributesController@create')->name('admin.catalog.attributes.create');
    Route::post('/attributes/create', 'AttributesController@store')->name('admin.catalog.attributes.store');
    Route::get('/attributes/{attribute}', 'AttributesController@show')->name('admin.catalog.attributes.show');
    Route::get('/attributes/{attribute}/edit', 'AttributesController@edit')->name('admin.catalog.attributes.edit');
    Route::post('/attributes/{attribute}/edit', 'AttributesController@update')->name('admin.catalog.attributes.update');
    Route::delete('/attributes/delete', 'AttributesController@destroyMany')->name('admin.catalog.attributes.destroyMany');
    Route::delete('/attributes/delete/{attribute}', 'AttributesController@destroy')->name('admin.catalog.attributes.destroy');

    // Catalog Menus Admin
    Route::any('/menus', 'MenusController@index')->name('admin.catalog.menus.index');
    Route::any('/menus/export', 'MenusController@index')->name('admin.catalog.menus.index.export');
    Route::get('/menus/create', 'MenusController@create')->name('admin.catalog.menus.create');
    Route::post('/menus/create', 'MenusController@store')->name('admin.catalog.menus.store');
    Route::get('/menus/{menu}', 'MenusController@show')->name('admin.catalog.menus.show');
    Route::get('/menus/{menu}/edit', 'MenusController@edit')->name('admin.catalog.menus.edit');
    Route::post('/menus/{menu}/edit', 'MenusController@update')->name('admin.catalog.menus.update');
    Route::delete('/menus/delete', 'MenusController@destroyMany')->name('admin.catalog.menus.destroyMany');
    Route::delete('/menus/delete/{menu}', 'MenusController@destroy')->name('admin.catalog.menus.destroy');

    // Catalog Items Admin
    Route::any('/items', 'ItemController@index')->name('admin.catalog.items.index');
    Route::any('/items/export', 'ItemController@index')->name('admin.catalog.items.index.export');
    Route::get('/items/create', 'ItemController@create')->name('admin.catalog.items.create');
    Route::post('/items/create', 'ItemController@store')->name('admin.catalog.items.store');
    Route::get('/items/duplicate/{item}', 'ItemController@duplicate')->name('admin.catalog.items.duplicate');
    Route::get('/items/toggle/{item}/{field}/{value}', 'ItemController@toggle')->name('admin.catalog.items.toggle');
    Route::get('/items/edit/{item}', 'ItemController@edit')->name('admin.catalog.items.edit');
    Route::post('/items/edit/{item}', 'ItemController@update')->name('admin.catalog.items.update');
    Route::delete('/items/delete', 'ItemController@destroyMany')->name('admin.catalog.items.destroyMany');
    Route::delete('/items/delete/{id}', 'ItemController@destroy')->name('admin.catalog.items.destroy');
    Route::get('/items/{item}', 'ItemController@show')->name('admin.catalog.items.show');

    // Vendors Admin
    Route::any('/vendors', 'VendorsController@index')->name('admin.catalog.vendors.index');
    Route::any('/vendors/export', 'VendorsController@index')->name('admin.catalog.vendors.index.export');
    Route::get('/vendors/create', 'VendorsController@create')->name('admin.catalog.vendors.create');
    Route::post('/vendors/create', 'VendorsController@store')->name('admin.catalog.vendors.store');
    Route::get('/vendors/edit/{vendor}', 'VendorsController@edit')->name('admin.catalog.vendors.edit');
    Route::post('/vendors/edit/{vendor}', 'VendorsController@update')->name('admin.catalog.vendors.update');
    Route::delete('/vendors/delete', 'VendorsController@destroyMany')->name('admin.catalog.vendors.destroyMany');
    Route::delete('/vendors/delete/{id}', 'VendorsController@destroy')->name('admin.catalog.vendors.destroy');
    Route::any('/vendors/{vendor}', 'VendorsController@show')->name('admin.catalog.vendors.show');

    // Orders Admin
    Route::delete('/orders/delete', 'OrdersController@destroyMany')->name('admin.catalog.orders.destroyMany');
    Route::delete('/orders/delete/{number}', 'OrdersController@destroy')->name('admin.catalog.orders.destroy');
    Route::any('/orders/{number}', 'OrdersController@show')->name('admin.catalog.orders.show');
    Route::post('/orders/{number}/export', 'OrdersController@show')->name('admin.catalog.orders.show.export');
    Route::put('/orders/{number}/edit', 'OrdersController@update')->name('admin.catalog.orders.update');

    Route::any('/orders', 'OrdersController@index')->name('admin.catalog.orders.index');
    Route::any('/orders/export', 'OrdersController@index')->name('admin.catalog.orders.index.export');

    Route::get('/orders/{number}/mark/cancel', 'OrdersController@cancel')->name('admin.catalog.orders.cancel');
    Route::post('/orders/mark/cancel', 'OrdersController@cancelMany')->name('admin.catalog.orders.cancelMany');
    Route::get('/orders/{number}/mark/process', 'OrdersController@process')->name('admin.catalog.orders.process');
    Route::post('/orders/mark/process', 'OrdersController@processMany')->name('admin.catalog.orders.processMany');

    Route::get('/orders/item/{orderItem}/mark/{status}', 'OrderItemsStatusController@edit')->name('admin.catalog.orders.item.status.edit');
    Route::post('/orders/item/{orderItem}/mark/{status}', 'OrderItemsStatusController@update')->name('admin.catalog.orders.item.status.update');
    Route::get('/orders/item/{orderItem}/inspect', 'OrderItemsController@inspect')->name('admin.catalog.orders.item.inspect');
});

Route::group([
    'middleware' => ['web', 'auth'],
    'namespace' => 'Api',
    'prefix' => '/api/catalog'
], function () {

    // Catalog Attributes Admin Api
    Route::get('/attributes', 'AttributesController@index')->name('api.catalog.attributes.index');

    // Catalog Options Admin Api
    Route::get('/options', 'OptionsController@index')->name('api.catalog.options.index');
    Route::get('/options/{item}', 'OptionsController@show')->name('api.catalog.options.show');

    // Catalog Menus Admin Api
    Route::get('/menus/items/{menu}', 'MenusController@items')->name('api.catalog.menus.items');
    Route::get('/menus/categories/{menu}', 'MenusController@categories')->name('api.catalog.menus.categories');
});
