<?php

namespace Ignite\Catalog\Http\Views;

use Ignite\Claim\Models\Summary\Metric;
use Illuminate\Support\Collection;
use Illuminate\View\View;

class OrderSummaryComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('summary', $summary = $this->decorate($this->query()->map(function ($metric) {
            return app(Metric::class, (array) $metric);
        })->keyBy(function ($metric) {
            return $metric->name();
        })));

        $view->with('summaryTotal', $summary->sum(function ($metric) {
            return (int) $metric->count();
        }));
    }

    /**
     * Query the metrics from the database.
     *
     * @return Collection
     */
    protected function query()
    {
        $processingQuery = app('db')->table('catalog_order')
            ->selectRaw('"processing" AS name, COUNT(*) AS count, SUM(points) AS total')
            ->where('processed', '!=', 1)
            ->where('cancelled', '!=', 1)
            ->where('user_id', auth()->id());

        $cancelledQuery = app('db')->table('catalog_order')
            ->selectRaw('"cancelled" AS name, COUNT(*) AS count, SUM(points) AS total')
            ->where('cancelled', '=', 1)
            ->where('user_id', auth()->id());

        return app('db')->table('catalog_order')
            ->selectRaw('"processed" AS name, COUNT(*) AS count, SUM(points) AS total')
            ->where('processed', '=', 1)
            ->where('user_id', auth()->id())
            ->union($processingQuery)
            ->union($cancelledQuery)
            ->get();
    }

    /**
     * Decorate the summary collection.
     *
     * @param  Collection $collection
     * @return Collection
     */
    protected function decorate(Collection $collection)
    {
        $allowedStatuses = ['processed', 'processing', 'cancelled'];

        foreach ($allowedStatuses as $allowedStatus) {
            if (! $collection->has($allowedStatus)) {
                $collection->push(app(Metric::class, [
                    'name' => $allowedStatus,
                    'count' => 0,
                    'total' => 0
                ]));
            }
        };

        return $collection->keyBy(function ($metric) {
            return $metric->name();
        });
    }
}