<?php

namespace Ignite\Catalog\Http\Controllers;

use Ignite\Catalog\Entities\Item;
use Ignite\Core\Http\Controllers\Controller;

class ItemController extends Controller
{
    /**
     * Show the item.
     *
     * @param  Item $item
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Item $item)
    {
        $item = $item->load('catalog');

        if (! session()->has('catalog') || session('catalog.id') !== $item->catalog->id) {
            session()->put('catalog', $item->catalog->toSessionData());

            return redirect()->route('catalog.show', $item->catalog->code);
        }

        return view('catalog.item.show', compact('item'));
    }
}
