<?php

namespace Ignite\Catalog\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\NavigationMenu;
use Ignite\Core\Program;

class AddCatalogItemsToNavigationMenu
{
    /**
     * @var Program
     */
    private $program;

    /**
     * AddCatalogItemsToNavigationMenu constructor.
     *
     * @param Program $program
     */
    public function __construct(Program $program)
    {
        $this->program = $program;
    }

    /**
     * Handle the event.
     *
     * @param NavigationMenuPreCompile|UserMenuPreCompile $event
     */
    public function handle($event)
    {
        if (! $this->program->isRedemption()) {
            return;
        }

        /** @todo Check if the module is disabled before adding this item */

        /** @var NavigationMenu $manager */
        $manager = $event->getManager();
        $item = new Item(url('/catalog/order'), 'My Orders', 40);

        if ($manager->has('/participant/profile') && $event instanceof NavigationMenuPreCompile) {
            $manager->get('/participant/profile')->addChild($item);
        }

        if ($event instanceof UserMenuPreCompile) {
            $manager->add($item);
        }
    }
}
