<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Illuminate\Support\Collection;
use Ignite\Catalog\Contracts\VendorHandler;
use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\Vendor;
use Ignite\Catalog\Jobs\Hawk\Reloadable as ReloadableJob;
use Ignite\Catalog\Vendors\DispatchesOrderItems;

class Reloadable implements VendorHandler
{
    use DispatchesOrderItems;

    /**
     * @var Vendor
     */
    private $vendor;

    /**
     * Egift constructor.
     *
     * @param Vendor $vendor
     */
    public function __construct(Vendor $vendor)
    {
        $this->vendor = $vendor;
    }

    /**
     * Handle the egift order items.
     *
     * @param  Order      $order
     * @param  Collection $orderItems
     */
    public function handle(Order $order, Collection $orderItems)
    {
        $this->dispatchOrderItems($orderItems, $order, ReloadableJob::class);
    }
}
